/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	Redirect
**
** DESCRIPTION:	Dispatches behaviours when a sprite is dropped in a redirect
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef REDIRECT_H
#define REDIRECT_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "ContentMap.h"
#include "../Villagers/Villager.h"

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/
const int Redirect_c_iMaxRedirectHandlers = CContentMap::eRedirector_NumberOf;

/******************************************************************************\
** TYPE DEFINITIONS
\******************************************************************************/
typedef void (* LPREDIRECTHANDLER)(CVillager &Villager);

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CRedirect
{
private:

	LPREDIRECTHANDLER	m_RedirectHandler[Redirect_c_iMaxRedirectHandlers];

	//class methods
	//setup
	public:		CRedirect(void);

	// process
	public:		const bool Dispatch(CVillager &Villager, const CContentMap::ERedirector eRedirector) const;

	private:	static void DivingRock(CVillager &Villager);

	// access
	public:		void SetHandler(const CContentMap::ERedirector eRedirector, LPREDIRECTHANDLER pHandler);
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CRedirect		Redirect;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/